/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MainGamePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GamePanel gp;
    private Flappybird fp;
    private Ground[] ground = new Ground[2];
    private JLabel score = new JLabel("0");
    private Obstacles[] obs = new Obstacles[3];
    private boolean isFly;
    private Timer timer;
    private ImageIcon Background = new ImageIcon("imgBackground/bakcground.png");
    private MainGamePanel mmp;
    private ImageIcon temp;
    private JLabel instruction = new JLabel("GET READY!");
    private JLabel tap = new JLabel("TAP!");
    public boolean isGif = true;
    public static boolean isdeath = false;

    public MainGamePanel(GamePanel p, ImageIcon x) {
        this.mmp = this;
        this.gp = p;
        this.fp = new Flappybird();
        this.timer = new Timer(12, new Move());
        this.temp = x;
        this.addMouseListener(new FlappyMouse());
        this.setBackground(Color.PINK);
        this.Ground();
        this.Obstacle();
        this.Label();
    }

    public void Obstacle() {
        int distance = 550;
        int i = 0;
        while (i < 3) {
            this.obs[i] = new Obstacles(this.gp, distance);
            distance += 210;
            ++i;
        }
    }

    public void Ground() {
        int distance = 0;
        int i = 0;
        while (i < 2) {
            this.ground[i] = new Ground(distance, 400);
            distance += 500;
            ++i;
        }
    }

    public void Label() {
        this.score.setBounds(240, 30, 100, 30);
        this.score.setFont(this.gp.getMyfont());
        this.add(this.score);
        this.tap.setBounds(140, 230, 100, 30);
        this.tap.setFont(this.gp.getTap());
        this.add(this.tap);
        this.instruction.setBounds(180, 120, 150, 30);
        this.instruction.setFont(this.gp.getTap());
        this.instruction.setForeground(Color.ORANGE);
        this.add(this.instruction);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.Background.paintIcon(this, g, 0, 0);
        int x = 0;
        while (x < 2) {
            this.ground[x].drawGround(this, g);
            ++x;
        }
        int i = 0;
        while (i < 3) {
            this.obs[i].drawObstacle(g);
            ++i;
        }
        this.fp.drawBird(this, g, this.fp.getGif(), this.temp);
        this.score.setBounds(240, 30, 100, 30);
        this.score.setText(this.gp.getScore());
    }

    private class FlappyMouse
    implements MouseListener {
        private FlappyMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!isdeath) {
                Flappybird.vertical_speed = -2.0;
                MainGamePanel.this.fp.setJump(true);
                MainGamePanel.this.remove(MainGamePanel.this.instruction);
                MainGamePanel.this.remove(MainGamePanel.this.tap);
                MainGamePanel.this.timer.start();
                MainGamePanel.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class Move
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            this.checkFly();
            this.Gravity();
            this.MoveGround();
            this.MoveObstacle();
            this.TestCollision();
            this.Jump();
        }

        public void MoveGround() {
            int i = 0;
            while (i < 2) {
                MainGamePanel.this.ground[i].addGroundX(-1);
                if (MainGamePanel.this.ground[i].getGroundX() < -495) {
                    MainGamePanel.this.ground[i].setGroundX(500);
                }
                ++i;
            }
            MainGamePanel.this.repaint();
        }

        public void Jump() {
            MainGamePanel.this.fp.setBirdY(Flappybird.vertical_speed);
            if (MainGamePanel.this.isFly) {
                MainGamePanel.this.fp.setGif(-1);
                if (MainGamePanel.this.fp.getGif() <= 0) {
                    MainGamePanel.this.fp.setGif(0);
                }
            }
            MainGamePanel.this.repaint();
        }

        public void Gravity() {
            Flappybird.vertical_speed += 0.1;
            if (!MainGamePanel.this.isFly) {
                MainGamePanel.this.fp.setGif(1);
                if (MainGamePanel.this.fp.getGif() >= 22) {
                    MainGamePanel.this.fp.setGif(22);
                }
            }
            if (Flappybird.vertical_speed >= 3.0) {
                Flappybird.vertical_speed = 3.0;
            }
            MainGamePanel.this.repaint();
            MainGamePanel.this.fp.setBirdY(Flappybird.vertical_speed);
        }

        public void checkFly() {
            if (Flappybird.vertical_speed <= 1.0) {
                MainGamePanel.this.isFly = true;
            } else {
                MainGamePanel.this.isFly = false;
            }
        }

        public void MoveObstacle() {
            int i = 0;
            while (i < 3) {
                MainGamePanel.this.obs[i].addObsX(-1);
                if (MainGamePanel.this.obs[i].getObsX() <= -50) {
                    MainGamePanel.this.obs[i].setObsX(550);
                    MainGamePanel.this.obs[i].randY1();
                    MainGamePanel.this.obs[i].addY2();
                }
                MainGamePanel.this.repaint();
                ++i;
            }
        }

        public void TestCollision() {
            int i = 0;
            while (i < 3) {
                if (MainGamePanel.this.fp.getBirdX2() >= MainGamePanel.this.obs[i].getObsX() && MainGamePanel.this.fp.getBirdX1() <= MainGamePanel.this.obs[i].getObsX() + 50) {
                    if (!(MainGamePanel.this.fp.getBirdY2() < MainGamePanel.this.obs[i].getY2()) || !(MainGamePanel.this.fp.getBirdY1() > (double)MainGamePanel.this.obs[i].getY1())) {
                        GameOverPanel x = new GameOverPanel(MainGamePanel.this.gp, MainGamePanel.this.mmp, MainGamePanel.this.gp.getScore(), MainGamePanel.this.gp.getHighScore());
                        x.setBounds(0, 0, 500, 500);
                        MainGamePanel.this.gp.repaint();
                        MainGamePanel.this.add(x);
                        MainGamePanel.this.remove(MainGamePanel.this.score);
                        MainGamePanel.this.timer.stop();
                        isdeath = true;
                    }
                    if (MainGamePanel.this.obs[i].getObsX() + 30 == MainGamePanel.this.fp.getBirdX1()) {
                        MainGamePanel.this.gp.addScore();
                    }
                }
                ++i;
            }
            if (MainGamePanel.this.fp.isGround()) {
                GameOverPanel x = new GameOverPanel(MainGamePanel.this.gp, MainGamePanel.this.mmp, MainGamePanel.this.gp.getScore(), MainGamePanel.this.gp.getHighScore());
                x.setBounds(0, 0, 500, 500);
                MainGamePanel.this.remove(MainGamePanel.this.score);
                MainGamePanel.this.gp.repaint();
                isdeath = true;
                MainGamePanel.this.add(x);
                MainGamePanel.this.timer.stop();
            }
            MainGamePanel.this.repaint();
        }
    }
}

